ALTER TABLE PATS.PATS_PATIENT
  DROP CONSTRAINT FK_PATIENT_ETHNICITY;


ALTER TABLE PATS.PATS_PATIENT ADD (
  CONSTRAINT FK_PATIENT_ETHNICITY 
  FOREIGN KEY (ETHNICITY_FK) 
  REFERENCES SDSADM.STD_ETHNICITY (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PATS.COMPS
  DROP CONSTRAINT FK_COMPS_INST;


ALTER TABLE PATS.COMPS ADD (
  CONSTRAINT FK_COMPS_INST 
  FOREIGN KEY (INSTITUTION_FK) 
  REFERENCES SDSADM.STD_INSTITUTION (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PATS.CONGRESSIONAL_CONTACT
  DROP CONSTRAINT FK_CC_INST;


ALTER TABLE PATS.CONGRESSIONAL_CONTACT ADD (
  CONSTRAINT FK_CC_INST 
  FOREIGN KEY (INSTITUTION_FK) 
  REFERENCES SDSADM.STD_INSTITUTION (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PATS.FACILITY_SERVICE_OR_SECTION
  DROP CONSTRAINT FK_FSOS_VISN;


ALTER TABLE PATS.FACILITY_SERVICE_OR_SECTION ADD (
  CONSTRAINT FK_FSOS_VISN 
  FOREIGN KEY (VISN_FK) 
  REFERENCES SDSADM.STD_INSTITUTION (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PATS.PATS_PATIENT
  DROP CONSTRAINT FK_PATIENT_INST;


ALTER TABLE PATS.PATS_PATIENT ADD (
  CONSTRAINT FK_PATIENT_INST 
  FOREIGN KEY (INSTITUTION_FK) 
  REFERENCES SDSADM.STD_INSTITUTION (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PATS.BOILERPLATE_RESOLUTION_TEXT
  DROP CONSTRAINT FK_BOILER_INST;


ALTER TABLE PATS.BOILERPLATE_RESOLUTION_TEXT ADD (
  CONSTRAINT FK_BOILER_INST 
  FOREIGN KEY (INSTITUTION_FK) 
  REFERENCES SDSADM.STD_INSTITUTION (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PATS.REPORT_OF_CONTACT
  DROP CONSTRAINT FK_ROC_INST;


ALTER TABLE PATS.REPORT_OF_CONTACT ADD (
  CONSTRAINT FK_ROC_INST 
  FOREIGN KEY (INSTITUTION_FK) 
  REFERENCES SDSADM.STD_INSTITUTION (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PATS.PATS_PATIENT_RACE
  DROP CONSTRAINT FK_PATIENT_RACE;


ALTER TABLE PATS.PATS_PATIENT_RACE ADD (
  CONSTRAINT FK_PATIENT_RACE 
  FOREIGN KEY (PATIENT_RACE_FK) 
  REFERENCES SDSADM.STD_RACE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);
ALTER TABLE PATS.REPORT_OF_CONTACT
  DROP CONSTRAINT FK_ROC_COMP;


ALTER TABLE PATS.REPORT_OF_CONTACT ADD (
  CONSTRAINT FK_ROC_COMP 
  FOREIGN KEY (COMP_FK) 
  REFERENCES PATS.COMPS (ID)
  ENABLE VALIDATE);
ALTER TABLE PATS.REPORT_OF_CONTACT
  DROP CONSTRAINT FK_ROC_CONGRESSIONAL_CONTACT;


ALTER TABLE PATS.REPORT_OF_CONTACT ADD (
  CONSTRAINT FK_ROC_CONGRESSIONAL_CONTACT 
  FOREIGN KEY (CONGRESSIONAL_CONTACT_FK) 
  REFERENCES PATS.CONGRESSIONAL_CONTACT (ID)
  ENABLE VALIDATE);
ALTER TABLE PATS.ROC_CONTACTING_ENTITY
  DROP CONSTRAINT FK_ROCCE_CE_ID;


ALTER TABLE PATS.ROC_CONTACTING_ENTITY ADD (
  CONSTRAINT FK_ROCCE_CE_ID 
  FOREIGN KEY (CONTACTING_ENTITY_FK) 
  REFERENCES PATS.CONTACTING_ENTITY (ID)
  ON DELETE CASCADE
  ENABLE VALIDATE);
ALTER TABLE PATS.ROC_ISSUE
  DROP CONSTRAINT FK_ROCISS_FSOS;


ALTER TABLE PATS.ROC_ISSUE ADD (
  CONSTRAINT FK_ROCISS_FSOS 
  FOREIGN KEY (FACILITY_SERVSECT_FK) 
  REFERENCES PATS.FACILITY_SERVICE_OR_SECTION (ID)
  ENABLE VALIDATE);
ALTER TABLE PATS.ROC_ISSUE
  DROP CONSTRAINT FK_ROCISS_HL;


ALTER TABLE PATS.ROC_ISSUE ADD (
  CONSTRAINT FK_ROCISS_HL 
  FOREIGN KEY (HOSPITAL_LOCATION_FK) 
  REFERENCES PATS.HOSPITAL_LOCATION (ID)
  ON DELETE CASCADE
  ENABLE VALIDATE);
ALTER TABLE PATS.ISSUE_CODE
  DROP CONSTRAINT FK_ISSUE_CODE_CATEGORY;


ALTER TABLE PATS.ISSUE_CODE ADD (
  CONSTRAINT FK_ISSUE_CODE_CATEGORY 
  FOREIGN KEY (ISSUE_CATEGORY_FK) 
  REFERENCES PATS.ISSUE_CATEGORY (ISSUE_CATEGORY_CODE)
  ENABLE VALIDATE);
ALTER TABLE PATS.BOILERPLATE_RESOLUTION_TEXT
  DROP CONSTRAINT FK_BOILER_ISSUE_CODE;


ALTER TABLE PATS.BOILERPLATE_RESOLUTION_TEXT ADD (
  CONSTRAINT FK_BOILER_ISSUE_CODE 
  FOREIGN KEY (ISSUE_CODE_FK) 
  REFERENCES PATS.ISSUE_CODE (ISSUE_CODE)
  ENABLE VALIDATE);
ALTER TABLE PATS.ROC_ISSUE
  DROP CONSTRAINT FK_ROCISS_ISSUE_CODE;


ALTER TABLE PATS.ROC_ISSUE ADD (
  CONSTRAINT FK_ROCISS_ISSUE_CODE 
  FOREIGN KEY (ISSUE_CODE_FK) 
  REFERENCES PATS.ISSUE_CODE (ISSUE_CODE)
  ON DELETE CASCADE
  ENABLE VALIDATE);
ALTER TABLE PATS.ROC_METHOD_OF_CONTACT
  DROP CONSTRAINT FK_ROCMOC_MOC;


ALTER TABLE PATS.ROC_METHOD_OF_CONTACT ADD (
  CONSTRAINT FK_ROCMOC_MOC 
  FOREIGN KEY (METHOD_OF_CONTACT_FK) 
  REFERENCES PATS.METHOD_OF_CONTACT (ID)
  ON DELETE CASCADE
  ENABLE VALIDATE);
ALTER TABLE PATS.PATS_PATIENT_RACE
  DROP CONSTRAINT FK_PATIENT;


ALTER TABLE PATS.PATS_PATIENT_RACE ADD (
  CONSTRAINT FK_PATIENT 
  FOREIGN KEY (PATIENT_FK) 
  REFERENCES PATS.PATS_PATIENT (ID)
  ON DELETE CASCADE
  ENABLE VALIDATE);
ALTER TABLE PATS.REPORT_OF_CONTACT
  DROP CONSTRAINT FK_ROC_PATIENT;


ALTER TABLE PATS.REPORT_OF_CONTACT ADD (
  CONSTRAINT FK_ROC_PATIENT 
  FOREIGN KEY (PATIENT_FK) 
  REFERENCES PATS.PATS_PATIENT (ID)
  ENABLE VALIDATE);
ALTER TABLE PATS.REPORT_OF_CONTACT
  DROP CONSTRAINT FK_ROC_INFO_TAKEN_BY_USER;


ALTER TABLE PATS.REPORT_OF_CONTACT ADD (
  CONSTRAINT FK_ROC_INFO_TAKEN_BY_USER 
  FOREIGN KEY (INFO_TAKEN_BY_USER_FK) 
  REFERENCES PATS.PATS_USER (ID)
  ENABLE VALIDATE);
ALTER TABLE PATS.REPORT_OF_CONTACT
  DROP CONSTRAINT FK_ROC_ENTERED_BY_USER;


ALTER TABLE PATS.REPORT_OF_CONTACT ADD (
  CONSTRAINT FK_ROC_ENTERED_BY_USER 
  FOREIGN KEY (ENTERED_BY_USER_FK) 
  REFERENCES PATS.PATS_USER (ID)
  ENABLE VALIDATE);
ALTER TABLE PATS.ROC_ISSUE
  DROP CONSTRAINT FK_ROCISS_EMPINV;


ALTER TABLE PATS.ROC_ISSUE ADD (
  CONSTRAINT FK_ROCISS_EMPINV 
  FOREIGN KEY (EMPLOYEE_INVOLVED_FK) 
  REFERENCES PATS.PATS_USER (ID)
  ON DELETE CASCADE
  ENABLE VALIDATE);
ALTER TABLE PATS.NOTIFICATION_MASTER
  DROP CONSTRAINT FK_NOTIFICATION_PA;


ALTER TABLE PATS.NOTIFICATION_MASTER ADD (
  CONSTRAINT FK_NOTIFICATION_PA 
  FOREIGN KEY (PATIENT_ADVOCATE_USER_FK) 
  REFERENCES PATS.PATS_USER (ID)
  ENABLE VALIDATE);
ALTER TABLE PATS.NOTIFICATION_MASTER
  DROP CONSTRAINT FK_NOTIFICATION_EMP_NOTIFIED;


ALTER TABLE PATS.NOTIFICATION_MASTER ADD (
  CONSTRAINT FK_NOTIFICATION_EMP_NOTIFIED 
  FOREIGN KEY (EMPLOYEE_NOTIFIED_FK) 
  REFERENCES PATS.PATS_USER (ID)
  ON DELETE CASCADE
  ENABLE VALIDATE);
ALTER TABLE PATS.NOTIFICATION_DETAIL
  DROP CONSTRAINT FK_NOTIFICATION_DETL_FROM_USER;


ALTER TABLE PATS.NOTIFICATION_DETAIL ADD (
  CONSTRAINT FK_NOTIFICATION_DETL_FROM_USER 
  FOREIGN KEY (FROM_USER_FK) 
  REFERENCES PATS.PATS_USER (ID)
  ENABLE VALIDATE);
ALTER TABLE PATS.NOTIFICATION_DETAIL
  DROP CONSTRAINT FK_NOTIFICATION_DETAIL_TO_USER;


ALTER TABLE PATS.NOTIFICATION_DETAIL ADD (
  CONSTRAINT FK_NOTIFICATION_DETAIL_TO_USER 
  FOREIGN KEY (TO_USER_FK) 
  REFERENCES PATS.PATS_USER (ID)
  ENABLE VALIDATE);
ALTER TABLE PATS.REPORT_OF_CONTACT
  DROP CONSTRAINT FK_ROC_TREATMENT_STATUS;


ALTER TABLE PATS.REPORT_OF_CONTACT ADD (
  CONSTRAINT FK_ROC_TREATMENT_STATUS 
  FOREIGN KEY (TREATMENT_STATUS_FK) 
  REFERENCES PATS.TREATMENT_STATUS (ID)
  ENABLE VALIDATE);
ALTER TABLE PATS.ROC_CONTACTING_ENTITY
  DROP CONSTRAINT FK_ROCCE_ROC_NUMBER;


ALTER TABLE PATS.ROC_CONTACTING_ENTITY ADD (
  CONSTRAINT FK_ROCCE_ROC_NUMBER 
  FOREIGN KEY (ROC_FK) 
  REFERENCES PATS.REPORT_OF_CONTACT (ROC_NUMBER)
  ON DELETE CASCADE
  ENABLE VALIDATE);
ALTER TABLE PATS.ROC_ISSUE
  DROP CONSTRAINT FK_ROCISS_ROC;


ALTER TABLE PATS.ROC_ISSUE ADD (
  CONSTRAINT FK_ROCISS_ROC 
  FOREIGN KEY (ROC_FK) 
  REFERENCES PATS.REPORT_OF_CONTACT (ROC_NUMBER)
  ON DELETE CASCADE
  ENABLE VALIDATE);
ALTER TABLE PATS.ROC_METHOD_OF_CONTACT
  DROP CONSTRAINT FK_ROCMOC_ROC;


ALTER TABLE PATS.ROC_METHOD_OF_CONTACT ADD (
  CONSTRAINT FK_ROCMOC_ROC 
  FOREIGN KEY (ROC_FK) 
  REFERENCES PATS.REPORT_OF_CONTACT (ROC_NUMBER)
  ON DELETE CASCADE
  ENABLE VALIDATE);
ALTER TABLE PATS.ROC_PHONE_FAX
  DROP CONSTRAINT FK_ROCPF_ROC;


ALTER TABLE PATS.ROC_PHONE_FAX ADD (
  CONSTRAINT FK_ROCPF_ROC 
  FOREIGN KEY (ROC_FK) 
  REFERENCES PATS.REPORT_OF_CONTACT (ROC_NUMBER)
  ON DELETE CASCADE
  ENABLE VALIDATE);
ALTER TABLE PATS.NOTIFICATION_MASTER
  DROP CONSTRAINT FK_NOTIFICATION_ROC;


ALTER TABLE PATS.NOTIFICATION_MASTER ADD (
  CONSTRAINT FK_NOTIFICATION_ROC 
  FOREIGN KEY (ROC_FK) 
  REFERENCES PATS.REPORT_OF_CONTACT (ROC_NUMBER)
  ON DELETE CASCADE
  ENABLE VALIDATE);
ALTER TABLE PATS.NOTIFICATION_DETAIL
  DROP CONSTRAINT FK_NOTIFICATION_DETAIL_MASTER;


ALTER TABLE PATS.NOTIFICATION_DETAIL ADD (
  CONSTRAINT FK_NOTIFICATION_DETAIL_MASTER 
  FOREIGN KEY (NOTIFICATION_MASTER_FK) 
  REFERENCES PATS.NOTIFICATION_MASTER (ID)
  ON DELETE CASCADE
  ENABLE VALIDATE);
ALTER TABLE PATS.PATS_ROLLUP_NATL_DATA
  DROP CONSTRAINT PK_ROLLUP_ID;

ALTER TABLE PATS.PATS_ROLLUP_NATL_DATA ADD (
  CONSTRAINT PK_ROLLUP_ID
  PRIMARY KEY
  (ID)
  ENABLE VALIDATE);
ALTER TABLE PATS.PATS_USER
  DROP CONSTRAINT U_USER_IDENTIFIER;

ALTER TABLE PATS.PATS_USER ADD (
  CONSTRAINT U_USER_IDENTIFIER
  UNIQUE (USER_IDENTIFIER)
  ENABLE VALIDATE);
ALTER TABLE PATS.TREATMENT_STATUS
  DROP CONSTRAINT U_TS_UPPERCASE_NAME;

ALTER TABLE PATS.TREATMENT_STATUS ADD (
  CONSTRAINT U_TS_UPPERCASE_NAME
  UNIQUE (UPPER_CASE_NAME)
  ENABLE VALIDATE);
ALTER TABLE PATS.TREATMENT_STATUS
  DROP CONSTRAINT U_TS_TREATMENT_STATUS;

ALTER TABLE PATS.TREATMENT_STATUS ADD (
  CONSTRAINT U_TS_TREATMENT_STATUS
  UNIQUE (TREATMENT_STATUS)
  ENABLE VALIDATE);
ALTER TABLE PATS.FACILITY_SERVICE_OR_SECTION
  DROP CONSTRAINT PK_FSOS_ID;

ALTER TABLE PATS.FACILITY_SERVICE_OR_SECTION ADD (
  CONSTRAINT PK_FSOS_ID
  PRIMARY KEY
  (ID)
  ENABLE VALIDATE);
ALTER TABLE PATS.PATS_PATIENT
  DROP CONSTRAINT U_PATIENT_INST_AND_VISTAIEN;

ALTER TABLE PATS.PATS_PATIENT ADD (
  CONSTRAINT U_PATIENT_INST_AND_VISTAIEN
  UNIQUE (INSTITUTION_FK, VISTA_IEN)
  ENABLE VALIDATE);
ALTER TABLE PATS.NOTIFICATION_MASTER
  DROP CONSTRAINT U_NOTIFICATION_QUERYSTRING;

ALTER TABLE PATS.NOTIFICATION_MASTER ADD (
  CONSTRAINT U_NOTIFICATION_QUERYSTRING
  UNIQUE (QUERYSTRING)
  ENABLE VALIDATE);
ALTER TABLE PATS.METHOD_OF_CONTACT
  DROP CONSTRAINT U_MOC_UPPERCASE_NAME;

ALTER TABLE PATS.METHOD_OF_CONTACT ADD (
  CONSTRAINT U_MOC_UPPERCASE_NAME
  UNIQUE (UPPER_CASE_NAME)
  ENABLE VALIDATE);
ALTER TABLE PATS.METHOD_OF_CONTACT
  DROP CONSTRAINT U_MOC_ROLLUP_CODE;

ALTER TABLE PATS.METHOD_OF_CONTACT ADD (
  CONSTRAINT U_MOC_ROLLUP_CODE
  UNIQUE (ROLLUP_CODE)
  ENABLE VALIDATE);
ALTER TABLE PATS.METHOD_OF_CONTACT
  DROP CONSTRAINT U_MOC_NAME;

ALTER TABLE PATS.METHOD_OF_CONTACT ADD (
  CONSTRAINT U_MOC_NAME
  UNIQUE (METHOD_OF_CONTACT_NAME)
  ENABLE VALIDATE);
ALTER TABLE PATS.ISSUE_CODE
  DROP CONSTRAINT U_ISSUE_CODE_UPPERCASE_NAME;

ALTER TABLE PATS.ISSUE_CODE ADD (
  CONSTRAINT U_ISSUE_CODE_UPPERCASE_NAME
  UNIQUE (UPPER_CASE_NAME, ISSUE_CATEGORY_FK)
  ENABLE VALIDATE);
ALTER TABLE PATS.ISSUE_CODE
  DROP CONSTRAINT U_ISSUE_CODE_NAME_AND_CATEGORY;

ALTER TABLE PATS.ISSUE_CODE ADD (
  CONSTRAINT U_ISSUE_CODE_NAME_AND_CATEGORY
  UNIQUE (ISSUE_CATEGORY_FK, ISSUE_CODE_NAME)
  ENABLE VALIDATE);
ALTER TABLE PATS.ISSUE_CATEGORY
  DROP CONSTRAINT U_ISSUE_CATEGORY_NAME;

ALTER TABLE PATS.ISSUE_CATEGORY ADD (
  CONSTRAINT U_ISSUE_CATEGORY_NAME
  UNIQUE (ISSUE_CATEGORY_NAME)
  ENABLE VALIDATE);
ALTER TABLE PATS.ISSUE_CATEGORY
  DROP CONSTRAINT U_ISSCAT_UPPERCASE_NAME;

ALTER TABLE PATS.ISSUE_CATEGORY ADD (
  CONSTRAINT U_ISSCAT_UPPERCASE_NAME
  UNIQUE (UPPER_CASE_NAME)
  ENABLE VALIDATE);
ALTER TABLE PATS.HOSPITAL_LOCATION
  DROP CONSTRAINT U_INST_AND_HLNAME;

ALTER TABLE PATS.HOSPITAL_LOCATION ADD (
  CONSTRAINT U_INST_AND_HLNAME
  UNIQUE (INSTITUTION_FK, LOCATION_NAME)
  ENABLE VALIDATE);
ALTER TABLE PATS.FACILITY_SERVICE_OR_SECTION
  DROP CONSTRAINT U_FSOS_NAME_VISN;

ALTER TABLE PATS.FACILITY_SERVICE_OR_SECTION ADD (
  CONSTRAINT U_FSOS_NAME_VISN
  UNIQUE (UPPER_CASE_NAME, VISN_FK)
  ENABLE VALIDATE);
ALTER TABLE PATS.COMPS
  DROP CONSTRAINT U_COMP_NAME_INST;

ALTER TABLE PATS.COMPS ADD (
  CONSTRAINT U_COMP_NAME_INST
  UNIQUE (UPPER_CASE_NAME, INSTITUTION_FK)
  ENABLE VALIDATE);
ALTER TABLE PATS.CONTACTING_ENTITY
  DROP CONSTRAINT U_CE_UPPERCASE_NAME;

ALTER TABLE PATS.CONTACTING_ENTITY ADD (
  CONSTRAINT U_CE_UPPERCASE_NAME
  UNIQUE (UPPER_CASE_NAME)
  ENABLE VALIDATE);
ALTER TABLE PATS.CONTACTING_ENTITY
  DROP CONSTRAINT U_CE_ROLLUP_CODE;

ALTER TABLE PATS.CONTACTING_ENTITY ADD (
  CONSTRAINT U_CE_ROLLUP_CODE
  UNIQUE (ROLLUP_CODE)
  ENABLE VALIDATE);
ALTER TABLE PATS.CONTACTING_ENTITY
  DROP CONSTRAINT U_CE_NAME;

ALTER TABLE PATS.CONTACTING_ENTITY ADD (
  CONSTRAINT U_CE_NAME
  UNIQUE (CONTACTING_ENTITY_NAME)
  ENABLE VALIDATE);
ALTER TABLE PATS.CONGRESSIONAL_CONTACT
  DROP CONSTRAINT U_CCNAME_INSTITUTION;

ALTER TABLE PATS.CONGRESSIONAL_CONTACT ADD (
  CONSTRAINT U_CCNAME_INSTITUTION
  UNIQUE (INSTITUTION_FK, OFFICE_OR_PERSON_NAME)
  ENABLE VALIDATE);
ALTER TABLE PATS.BOILERPLATE_RESOLUTION_TEXT
  DROP CONSTRAINT U_BOILER_ISSCODE_INST;

ALTER TABLE PATS.BOILERPLATE_RESOLUTION_TEXT ADD (
  CONSTRAINT U_BOILER_ISSCODE_INST
  UNIQUE (INSTITUTION_FK, ISSUE_CODE_FK)
  ENABLE VALIDATE);
ALTER TABLE PATS.PATS_USER
  DROP CONSTRAINT PK_USER_ID;

ALTER TABLE PATS.PATS_USER ADD (
  CONSTRAINT PK_USER_ID
  PRIMARY KEY
  (ID)
  ENABLE VALIDATE);
ALTER TABLE PATS.REPORT_OF_CONTACT
  DROP CONSTRAINT PK_ROC_NUMBER;

ALTER TABLE PATS.REPORT_OF_CONTACT ADD (
  CONSTRAINT PK_ROC_NUMBER
  PRIMARY KEY
  (ROC_NUMBER)
  ENABLE VALIDATE);
ALTER TABLE PATS.ROC_PHONE_FAX
  DROP CONSTRAINT PK_ROCPF_ID;

ALTER TABLE PATS.ROC_PHONE_FAX ADD (
  CONSTRAINT PK_ROCPF_ID
  PRIMARY KEY
  (ID)
  ENABLE VALIDATE);
ALTER TABLE PATS.ROC_METHOD_OF_CONTACT
  DROP CONSTRAINT PK_ROCMOC_ID;

ALTER TABLE PATS.ROC_METHOD_OF_CONTACT ADD (
  CONSTRAINT PK_ROCMOC_ID
  PRIMARY KEY
  (ID)
  ENABLE VALIDATE);
ALTER TABLE PATS.ROC_ISSUE
  DROP CONSTRAINT PK_ROCISS_ID;

ALTER TABLE PATS.ROC_ISSUE ADD (
  CONSTRAINT PK_ROCISS_ID
  PRIMARY KEY
  (ID)
  ENABLE VALIDATE);
ALTER TABLE PATS.ROC_CONTACTING_ENTITY
  DROP CONSTRAINT PK_ROCCE_ID;

ALTER TABLE PATS.ROC_CONTACTING_ENTITY ADD (
  CONSTRAINT PK_ROCCE_ID
  PRIMARY KEY
  (ID)
  ENABLE VALIDATE);
ALTER TABLE PATS.PATS_PATIENT_RACE
  DROP CONSTRAINT PK_PATS_PATIENT_RACE;

ALTER TABLE PATS.PATS_PATIENT_RACE ADD (
  CONSTRAINT PK_PATS_PATIENT_RACE
  PRIMARY KEY
  (ID)
  ENABLE VALIDATE);
ALTER TABLE PATS.PATS_PATIENT
  DROP CONSTRAINT PK_PATIENT_ID;

ALTER TABLE PATS.PATS_PATIENT ADD (
  CONSTRAINT PK_PATIENT_ID
  PRIMARY KEY
  (ID)
  ENABLE VALIDATE);
ALTER TABLE PATS.PAD_LOCATION
  DROP CONSTRAINT PK_PADLOC_ID;

ALTER TABLE PATS.PAD_LOCATION ADD (
  CONSTRAINT PK_PADLOC_ID
  PRIMARY KEY
  (ID)
  ENABLE VALIDATE);
ALTER TABLE PATS.NOTIFICATION_MASTER
  DROP CONSTRAINT PK_NOTIFICATION_MASTER;

ALTER TABLE PATS.NOTIFICATION_MASTER ADD (
  CONSTRAINT PK_NOTIFICATION_MASTER
  PRIMARY KEY
  (ID)
  ENABLE VALIDATE);
ALTER TABLE PATS.NOTIFICATION_DETAIL
  DROP CONSTRAINT PK_NOTIFICATION_DETAIL_ID;

ALTER TABLE PATS.NOTIFICATION_DETAIL ADD (
  CONSTRAINT PK_NOTIFICATION_DETAIL_ID
  PRIMARY KEY
  (ID)
  ENABLE VALIDATE);
ALTER TABLE PATS.NATIONAL_PATS_PARAMETERS
  DROP CONSTRAINT PK_NATIONAL_PATS_PARAMETERS;

ALTER TABLE PATS.NATIONAL_PATS_PARAMETERS ADD (
  CONSTRAINT PK_NATIONAL_PATS_PARAMETERS
  PRIMARY KEY
  (ID)
  ENABLE VALIDATE);
ALTER TABLE PATS.METHOD_OF_CONTACT
  DROP CONSTRAINT PK_MOC_ID;

ALTER TABLE PATS.METHOD_OF_CONTACT ADD (
  CONSTRAINT PK_MOC_ID
  PRIMARY KEY
  (ID)
  ENABLE VALIDATE);
ALTER TABLE PATS.ISSUE_CODE
  DROP CONSTRAINT PK_ISSUE_CODE;

ALTER TABLE PATS.ISSUE_CODE ADD (
  CONSTRAINT PK_ISSUE_CODE
  PRIMARY KEY
  (ISSUE_CODE)
  ENABLE VALIDATE);
ALTER TABLE PATS.ISSUE_CATEGORY
  DROP CONSTRAINT PK_ISSUE_CATEGORY_CODE;

ALTER TABLE PATS.ISSUE_CATEGORY ADD (
  CONSTRAINT PK_ISSUE_CATEGORY_CODE
  PRIMARY KEY
  (ISSUE_CATEGORY_CODE)
  ENABLE VALIDATE);
ALTER TABLE PATS.TREATMENT_STATUS
  DROP CONSTRAINT PK_ID;

ALTER TABLE PATS.TREATMENT_STATUS ADD (
  CONSTRAINT PK_ID
  PRIMARY KEY
  (ID)
  ENABLE VALIDATE);
ALTER TABLE PATS.HOSPITAL_LOCATION
  DROP CONSTRAINT PK_HL_ID;

ALTER TABLE PATS.HOSPITAL_LOCATION ADD (
  CONSTRAINT PK_HL_ID
  PRIMARY KEY
  (ID)
  ENABLE VALIDATE);
ALTER TABLE PATS.DMLOG
  DROP CONSTRAINT PK_DMLOG_ID;

ALTER TABLE PATS.DMLOG ADD (
  CONSTRAINT PK_DMLOG_ID
  PRIMARY KEY
  (ID)
  ENABLE VALIDATE);
ALTER TABLE PATS.COMPS
  DROP CONSTRAINT PK_COMPS;

ALTER TABLE PATS.COMPS ADD (
  CONSTRAINT PK_COMPS
  PRIMARY KEY
  (ID)
  ENABLE VALIDATE);
ALTER TABLE PATS.CONTACTING_ENTITY
  DROP CONSTRAINT PK_CE_ID;

ALTER TABLE PATS.CONTACTING_ENTITY ADD (
  CONSTRAINT PK_CE_ID
  PRIMARY KEY
  (ID)
  ENABLE VALIDATE);
ALTER TABLE PATS.CONGRESSIONAL_CONTACT
  DROP CONSTRAINT PK_CC_ID;

ALTER TABLE PATS.CONGRESSIONAL_CONTACT ADD (
  CONSTRAINT PK_CC_ID
  PRIMARY KEY
  (ID)
  ENABLE VALIDATE);
ALTER TABLE PATS.BOILERPLATE_RESOLUTION_TEXT
  DROP CONSTRAINT PK_BOILER_ID;

ALTER TABLE PATS.BOILERPLATE_RESOLUTION_TEXT ADD (
  CONSTRAINT PK_BOILER_ID
  PRIMARY KEY
  (ID)
  ENABLE VALIDATE);
ALTER TABLE PATS.COMPS MODIFY 
  COMP_NAME NULL;

ALTER TABLE PATS.COMPS MODIFY 
  COMP_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.COMPS MODIFY 
  INSTITUTION_FK NULL;

ALTER TABLE PATS.COMPS MODIFY 
  INSTITUTION_FK NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.COMPS MODIFY 
  VER NULL;

ALTER TABLE PATS.COMPS MODIFY 
  VER NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.CONGRESSIONAL_CONTACT MODIFY 
  ID NULL;

ALTER TABLE PATS.CONGRESSIONAL_CONTACT MODIFY 
  ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.CONGRESSIONAL_CONTACT MODIFY 
  OFFICE_OR_PERSON_NAME NULL;

ALTER TABLE PATS.CONGRESSIONAL_CONTACT MODIFY 
  OFFICE_OR_PERSON_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.CONGRESSIONAL_CONTACT MODIFY 
  INSTITUTION_FK NULL;

ALTER TABLE PATS.CONGRESSIONAL_CONTACT MODIFY 
  INSTITUTION_FK NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.CONGRESSIONAL_CONTACT MODIFY 
  VER NULL;

ALTER TABLE PATS.CONGRESSIONAL_CONTACT MODIFY 
  VER NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.CONGRESSIONAL_CONTACT MODIFY 
  UPPER_CASE_NAME NULL;

ALTER TABLE PATS.CONGRESSIONAL_CONTACT MODIFY 
  UPPER_CASE_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.CONTACTING_ENTITY MODIFY 
  ID NULL;

ALTER TABLE PATS.CONTACTING_ENTITY MODIFY 
  ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.CONTACTING_ENTITY MODIFY 
  CONTACTING_ENTITY_NAME NULL;

ALTER TABLE PATS.CONTACTING_ENTITY MODIFY 
  CONTACTING_ENTITY_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.CONTACTING_ENTITY MODIFY 
  VER NULL;

ALTER TABLE PATS.CONTACTING_ENTITY MODIFY 
  VER NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.CONTACTING_ENTITY MODIFY 
  SORT_ORDER NULL;

ALTER TABLE PATS.CONTACTING_ENTITY MODIFY 
  SORT_ORDER NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.CONTACTING_ENTITY MODIFY 
  ROLLUP_CODE NULL;

ALTER TABLE PATS.CONTACTING_ENTITY MODIFY 
  ROLLUP_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.FACILITY_SERVICE_OR_SECTION MODIFY 
  ID NULL;

ALTER TABLE PATS.FACILITY_SERVICE_OR_SECTION MODIFY 
  ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.FACILITY_SERVICE_OR_SECTION MODIFY 
  SERVICE_OR_SECTION_NAME NULL;

ALTER TABLE PATS.FACILITY_SERVICE_OR_SECTION MODIFY 
  SERVICE_OR_SECTION_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.FACILITY_SERVICE_OR_SECTION MODIFY 
  VISN_FK NULL;

ALTER TABLE PATS.FACILITY_SERVICE_OR_SECTION MODIFY 
  VISN_FK NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.FACILITY_SERVICE_OR_SECTION MODIFY 
  VER NULL;

ALTER TABLE PATS.FACILITY_SERVICE_OR_SECTION MODIFY 
  VER NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.FACILITY_SERVICE_OR_SECTION MODIFY 
  UPPER_CASE_NAME NULL;

ALTER TABLE PATS.FACILITY_SERVICE_OR_SECTION MODIFY 
  UPPER_CASE_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.HOSPITAL_LOCATION MODIFY 
  ID NULL;

ALTER TABLE PATS.HOSPITAL_LOCATION MODIFY 
  ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.HOSPITAL_LOCATION MODIFY 
  LOCATION_NAME NULL;

ALTER TABLE PATS.HOSPITAL_LOCATION MODIFY 
  LOCATION_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.HOSPITAL_LOCATION MODIFY 
  INSTITUTION_FK NULL;

ALTER TABLE PATS.HOSPITAL_LOCATION MODIFY 
  INSTITUTION_FK NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.HOSPITAL_LOCATION MODIFY 
  VER NULL;

ALTER TABLE PATS.HOSPITAL_LOCATION MODIFY 
  VER NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.HOSPITAL_LOCATION MODIFY 
  UPPER_CASE_NAME NULL;

ALTER TABLE PATS.HOSPITAL_LOCATION MODIFY 
  UPPER_CASE_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.ISSUE_CATEGORY MODIFY 
  ISSUE_CATEGORY_CODE NULL;

ALTER TABLE PATS.ISSUE_CATEGORY MODIFY 
  ISSUE_CATEGORY_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.ISSUE_CATEGORY MODIFY 
  ISSUE_CATEGORY_NAME NULL;

ALTER TABLE PATS.ISSUE_CATEGORY MODIFY 
  ISSUE_CATEGORY_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.ISSUE_CATEGORY MODIFY 
  VER NULL;

ALTER TABLE PATS.ISSUE_CATEGORY MODIFY 
  VER NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.ISSUE_CATEGORY MODIFY 
  SORT_ORDER NULL;

ALTER TABLE PATS.ISSUE_CATEGORY MODIFY 
  SORT_ORDER NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.ISSUE_CATEGORY
  DROP CONSTRAINT CK_IS_CUST_SERV_STD;

ALTER TABLE PATS.ISSUE_CATEGORY ADD (
  CONSTRAINT CK_IS_CUST_SERV_STD
  CHECK (is_customer_service_standard=0 OR is_customer_service_standard=1)
  ENABLE VALIDATE);
ALTER TABLE PATS.ISSUE_CODE MODIFY 
  ISSUE_CODE NULL;

ALTER TABLE PATS.ISSUE_CODE MODIFY 
  ISSUE_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.ISSUE_CODE MODIFY 
  ISSUE_CODE_NAME NULL;

ALTER TABLE PATS.ISSUE_CODE MODIFY 
  ISSUE_CODE_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.ISSUE_CODE MODIFY 
  ISSUE_CATEGORY_FK NULL;

ALTER TABLE PATS.ISSUE_CODE MODIFY 
  ISSUE_CATEGORY_FK NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.ISSUE_CODE MODIFY 
  VER NULL;

ALTER TABLE PATS.ISSUE_CODE MODIFY 
  VER NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.ISSUE_CODE
  DROP CONSTRAINT CK_ISSUE_CODE;

ALTER TABLE PATS.ISSUE_CODE ADD (
  CONSTRAINT CK_ISSUE_CODE
  CHECK (SUBSTR(ISSUE_CODE,1,LENGTH(ISSUE_CATEGORY_FK))=ISSUE_CATEGORY_FK)
  ENABLE VALIDATE);
ALTER TABLE PATS.METHOD_OF_CONTACT MODIFY 
  ID NULL;

ALTER TABLE PATS.METHOD_OF_CONTACT MODIFY 
  ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.METHOD_OF_CONTACT MODIFY 
  METHOD_OF_CONTACT_NAME NULL;

ALTER TABLE PATS.METHOD_OF_CONTACT MODIFY 
  METHOD_OF_CONTACT_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.METHOD_OF_CONTACT MODIFY 
  SORT_ORDER NULL;

ALTER TABLE PATS.METHOD_OF_CONTACT MODIFY 
  SORT_ORDER NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.METHOD_OF_CONTACT MODIFY 
  VER NULL;

ALTER TABLE PATS.METHOD_OF_CONTACT MODIFY 
  VER NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.METHOD_OF_CONTACT MODIFY 
  ROLLUP_CODE NULL;

ALTER TABLE PATS.METHOD_OF_CONTACT MODIFY 
  ROLLUP_CODE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.NATIONAL_PATS_PARAMETERS MODIFY 
  DAYS_TO_PROCESS_ROC NULL;

ALTER TABLE PATS.NATIONAL_PATS_PARAMETERS MODIFY 
  DAYS_TO_PROCESS_ROC NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.NATIONAL_PATS_PARAMETERS MODIFY 
  DATE_EDITED NULL;

ALTER TABLE PATS.NATIONAL_PATS_PARAMETERS MODIFY 
  DATE_EDITED NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.NATIONAL_PATS_PARAMETERS
  DROP CONSTRAINT CK_NATL_PARAM_ID;

ALTER TABLE PATS.NATIONAL_PATS_PARAMETERS ADD (
  CONSTRAINT CK_NATL_PARAM_ID
  CHECK (ID=1)
  ENABLE VALIDATE);
ALTER TABLE PATS.PATS_PATIENT MODIFY 
  ID NULL;

ALTER TABLE PATS.PATS_PATIENT MODIFY 
  ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.PATS_PATIENT MODIFY 
  LAST_NAME NULL;

ALTER TABLE PATS.PATS_PATIENT MODIFY 
  LAST_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.PATS_PATIENT MODIFY 
  FIRST_NAME NULL;

ALTER TABLE PATS.PATS_PATIENT MODIFY 
  FIRST_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.PATS_PATIENT MODIFY 
  GENDER NULL;

ALTER TABLE PATS.PATS_PATIENT MODIFY 
  GENDER NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.PATS_PATIENT MODIFY 
  DATE_OF_BIRTH NULL;

ALTER TABLE PATS.PATS_PATIENT MODIFY 
  DATE_OF_BIRTH NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.PATS_PATIENT MODIFY 
  INSTITUTION_FK NULL;

ALTER TABLE PATS.PATS_PATIENT MODIFY 
  INSTITUTION_FK NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.PATS_PATIENT MODIFY 
  VISTA_IEN NULL;

ALTER TABLE PATS.PATS_PATIENT MODIFY 
  VISTA_IEN NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.PATS_PATIENT MODIFY 
  STD_NAME_FOR_LOOKUP NULL;

ALTER TABLE PATS.PATS_PATIENT MODIFY 
  STD_NAME_FOR_LOOKUP NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.PATS_PATIENT MODIFY 
  STD_FIRST_NAME NULL;

ALTER TABLE PATS.PATS_PATIENT MODIFY 
  STD_FIRST_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.PATS_PATIENT
  DROP CONSTRAINT CK_GENDER;

ALTER TABLE PATS.PATS_PATIENT ADD (
  CONSTRAINT CK_GENDER
  CHECK (gender='M' OR gender='F')
  ENABLE VALIDATE);
ALTER TABLE PATS.PATS_PATIENT_RACE MODIFY 
  ID NULL;

ALTER TABLE PATS.PATS_PATIENT_RACE MODIFY 
  ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.PATS_PATIENT_RACE MODIFY 
  PATIENT_RACE_FK NULL;

ALTER TABLE PATS.PATS_PATIENT_RACE MODIFY 
  PATIENT_RACE_FK NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.PATS_PATIENT_RACE MODIFY 
  PATIENT_FK NULL;

ALTER TABLE PATS.PATS_PATIENT_RACE MODIFY 
  PATIENT_FK NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.PATS_ROLLUP_NATL_DATA MODIFY 
  ID NULL;

ALTER TABLE PATS.PATS_ROLLUP_NATL_DATA MODIFY 
  ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.PATS_ROLLUP_NATL_DATA MODIFY 
  ROC_NUMBER NULL;

ALTER TABLE PATS.PATS_ROLLUP_NATL_DATA MODIFY 
  ROC_NUMBER NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.PATS_ROLLUP_NATL_DATA MODIFY 
  OUTPUT_DATA_STRING NULL;

ALTER TABLE PATS.PATS_ROLLUP_NATL_DATA MODIFY 
  OUTPUT_DATA_STRING NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.PATS_ROLLUP_NATL_DATA MODIFY 
  DATE_GENERATED NULL;

ALTER TABLE PATS.PATS_ROLLUP_NATL_DATA MODIFY 
  DATE_GENERATED NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.PATS_USER MODIFY 
  USER_IDENTIFIER NULL;

ALTER TABLE PATS.PATS_USER MODIFY 
  USER_IDENTIFIER NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.PATS_USER MODIFY 
  LAST_NAME NULL;

ALTER TABLE PATS.PATS_USER MODIFY 
  LAST_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.PATS_USER MODIFY 
  FIRST_NAME NULL;

ALTER TABLE PATS.PATS_USER MODIFY 
  FIRST_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.PATS_USER MODIFY 
  STD_NAME_FOR_LOOKUP NULL;

ALTER TABLE PATS.PATS_USER MODIFY 
  STD_NAME_FOR_LOOKUP NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.PATS_USER MODIFY 
  STD_FIRST_NAME NULL;

ALTER TABLE PATS.PATS_USER MODIFY 
  STD_FIRST_NAME NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.PATS_USER MODIFY 
  ID NULL;

ALTER TABLE PATS.PATS_USER MODIFY 
  ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.PATS_USER MODIFY 
  PARENT_INSTITUTION_FK NULL;

ALTER TABLE PATS.PATS_USER MODIFY 
  PARENT_INSTITUTION_FK NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.PATS_USER
  DROP CONSTRAINT CHK_IS_508_ACCESSIBLE;

ALTER TABLE PATS.PATS_USER ADD (
  CONSTRAINT CHK_IS_508_ACCESSIBLE
  CHECK ((is_508_accessible IS NULL) OR (is_508_accessible=0) OR (is_508_accessible=1))
  ENABLE VALIDATE);
ALTER TABLE PATS.PATS_USER
  DROP CONSTRAINT CK_USER_DISPLAY_EXP_ARN;

ALTER TABLE PATS.PATS_USER ADD (
  CONSTRAINT CK_USER_DISPLAY_EXP_ARN
  CHECK ((display_expired_arns IS NULL) OR (display_expired_arns=1) OR (display_expired_arns=0))
  ENABLE VALIDATE);
ALTER TABLE PATS.TREATMENT_STATUS MODIFY 
  ID NULL;

ALTER TABLE PATS.TREATMENT_STATUS MODIFY 
  ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.TREATMENT_STATUS MODIFY 
  TREATMENT_STATUS NULL;

ALTER TABLE PATS.TREATMENT_STATUS MODIFY 
  TREATMENT_STATUS NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.TREATMENT_STATUS MODIFY 
  SORT_ORDER NULL;

ALTER TABLE PATS.TREATMENT_STATUS MODIFY 
  SORT_ORDER NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.TREATMENT_STATUS MODIFY 
  VER NULL;

ALTER TABLE PATS.TREATMENT_STATUS MODIFY 
  VER NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.BOILERPLATE_RESOLUTION_TEXT MODIFY 
  ID NULL;

ALTER TABLE PATS.BOILERPLATE_RESOLUTION_TEXT MODIFY 
  ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.BOILERPLATE_RESOLUTION_TEXT MODIFY 
  INSTITUTION_FK NULL;

ALTER TABLE PATS.BOILERPLATE_RESOLUTION_TEXT MODIFY 
  INSTITUTION_FK NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.BOILERPLATE_RESOLUTION_TEXT MODIFY 
  ISSUE_CODE_FK NULL;

ALTER TABLE PATS.BOILERPLATE_RESOLUTION_TEXT MODIFY 
  ISSUE_CODE_FK NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.BOILERPLATE_RESOLUTION_TEXT MODIFY 
  TEXT NULL;

ALTER TABLE PATS.BOILERPLATE_RESOLUTION_TEXT MODIFY 
  TEXT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.BOILERPLATE_RESOLUTION_TEXT MODIFY 
  VER NULL;

ALTER TABLE PATS.BOILERPLATE_RESOLUTION_TEXT MODIFY 
  VER NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.REPORT_OF_CONTACT MODIFY 
  ROC_NUMBER NULL;

ALTER TABLE PATS.REPORT_OF_CONTACT MODIFY 
  ROC_NUMBER NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.REPORT_OF_CONTACT MODIFY 
  DATE_OF_CONTACT NULL;

ALTER TABLE PATS.REPORT_OF_CONTACT MODIFY 
  DATE_OF_CONTACT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.REPORT_OF_CONTACT MODIFY 
  INFO_TAKEN_BY_USER_FK NULL;

ALTER TABLE PATS.REPORT_OF_CONTACT MODIFY 
  INFO_TAKEN_BY_USER_FK NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.REPORT_OF_CONTACT MODIFY 
  ENTERED_BY_USER_FK NULL;

ALTER TABLE PATS.REPORT_OF_CONTACT MODIFY 
  ENTERED_BY_USER_FK NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.REPORT_OF_CONTACT MODIFY 
  TREATMENT_STATUS_FK NULL;

ALTER TABLE PATS.REPORT_OF_CONTACT MODIFY 
  TREATMENT_STATUS_FK NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.REPORT_OF_CONTACT MODIFY 
  IS_INTERNAL_APPEAL NULL;

ALTER TABLE PATS.REPORT_OF_CONTACT MODIFY 
  IS_INTERNAL_APPEAL NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.REPORT_OF_CONTACT MODIFY 
  STATUS NULL;

ALTER TABLE PATS.REPORT_OF_CONTACT MODIFY 
  STATUS NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.REPORT_OF_CONTACT MODIFY 
  INSTITUTION_FK NULL;

ALTER TABLE PATS.REPORT_OF_CONTACT MODIFY 
  INSTITUTION_FK NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.REPORT_OF_CONTACT MODIFY 
  VER NULL;

ALTER TABLE PATS.REPORT_OF_CONTACT MODIFY 
  VER NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.REPORT_OF_CONTACT MODIFY 
  ISSUE_TEXT NULL;

ALTER TABLE PATS.REPORT_OF_CONTACT MODIFY 
  ISSUE_TEXT NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.REPORT_OF_CONTACT MODIFY 
  ROLLUP_TO_NATL_REPORTS_STATUS NULL;

ALTER TABLE PATS.REPORT_OF_CONTACT MODIFY 
  ROLLUP_TO_NATL_REPORTS_STATUS NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.REPORT_OF_CONTACT
  DROP CONSTRAINT CK_IS_INTERNAL_APPEAL;

ALTER TABLE PATS.REPORT_OF_CONTACT ADD (
  CONSTRAINT CK_IS_INTERNAL_APPEAL
  CHECK (is_internal_appeal=0 OR is_internal_appeal=1)
  ENABLE VALIDATE);
ALTER TABLE PATS.REPORT_OF_CONTACT
  DROP CONSTRAINT CK_ROC_DATE_CLOSED;

ALTER TABLE PATS.REPORT_OF_CONTACT ADD (
  CONSTRAINT CK_ROC_DATE_CLOSED
  CHECK ((DATE_CLOSED IS NULL) OR (DATE_CLOSED >= DATE_OF_CONTACT))
  ENABLE VALIDATE);
ALTER TABLE PATS.REPORT_OF_CONTACT
  DROP CONSTRAINT CK_ROC_DATE_OVERDUE;

ALTER TABLE PATS.REPORT_OF_CONTACT ADD (
  CONSTRAINT CK_ROC_DATE_OVERDUE
  CHECK ((DATE_OVERDUE IS NULL) OR (DATE_OVERDUE >= DATE_OF_CONTACT))
  ENABLE VALIDATE);
ALTER TABLE PATS.REPORT_OF_CONTACT
  DROP CONSTRAINT CK_ROC_ROLLUP_STATUS;

ALTER TABLE PATS.REPORT_OF_CONTACT ADD (
  CONSTRAINT CK_ROC_ROLLUP_STATUS
  CHECK ((rollup_to_natl_reports_status=0) OR (rollup_to_natl_reports_status=1))
  ENABLE VALIDATE);
ALTER TABLE PATS.REPORT_OF_CONTACT
  DROP CONSTRAINT CK_STATUS;

ALTER TABLE PATS.REPORT_OF_CONTACT ADD (
  CONSTRAINT CK_STATUS
  CHECK ((status='O') OR (status='C'))
  ENABLE VALIDATE);
ALTER TABLE PATS.ROC_CONTACTING_ENTITY MODIFY 
  ID NULL;

ALTER TABLE PATS.ROC_CONTACTING_ENTITY MODIFY 
  ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.ROC_CONTACTING_ENTITY MODIFY 
  ROC_FK NULL;

ALTER TABLE PATS.ROC_CONTACTING_ENTITY MODIFY 
  ROC_FK NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.ROC_CONTACTING_ENTITY MODIFY 
  CONTACTING_ENTITY_FK NULL;

ALTER TABLE PATS.ROC_CONTACTING_ENTITY MODIFY 
  CONTACTING_ENTITY_FK NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.ROC_ISSUE MODIFY 
  ID NULL;

ALTER TABLE PATS.ROC_ISSUE MODIFY 
  ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.ROC_ISSUE MODIFY 
  ROC_FK NULL;

ALTER TABLE PATS.ROC_ISSUE MODIFY 
  ROC_FK NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.ROC_ISSUE MODIFY 
  ISSUE_CODE_FK NULL;

ALTER TABLE PATS.ROC_ISSUE MODIFY 
  ISSUE_CODE_FK NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.ROC_ISSUE MODIFY 
  FACILITY_SERVSECT_FK NULL;

ALTER TABLE PATS.ROC_ISSUE MODIFY 
  FACILITY_SERVSECT_FK NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.ROC_METHOD_OF_CONTACT MODIFY 
  ID NULL;

ALTER TABLE PATS.ROC_METHOD_OF_CONTACT MODIFY 
  ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.ROC_METHOD_OF_CONTACT MODIFY 
  METHOD_OF_CONTACT_FK NULL;

ALTER TABLE PATS.ROC_METHOD_OF_CONTACT MODIFY 
  METHOD_OF_CONTACT_FK NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.ROC_METHOD_OF_CONTACT MODIFY 
  ROC_FK NULL;

ALTER TABLE PATS.ROC_METHOD_OF_CONTACT MODIFY 
  ROC_FK NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.ROC_PHONE_FAX MODIFY 
  ID NULL;

ALTER TABLE PATS.ROC_PHONE_FAX MODIFY 
  ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.ROC_PHONE_FAX MODIFY 
  PHONE_FAX_NUMBER NULL;

ALTER TABLE PATS.ROC_PHONE_FAX MODIFY 
  PHONE_FAX_NUMBER NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.ROC_PHONE_FAX MODIFY 
  ROC_FK NULL;

ALTER TABLE PATS.ROC_PHONE_FAX MODIFY 
  ROC_FK NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.NOTIFICATION_MASTER
  DROP CONSTRAINT CK_NOTIFICATION_STATUS;

ALTER TABLE PATS.NOTIFICATION_MASTER ADD (
  CONSTRAINT CK_NOTIFICATION_STATUS
  CHECK ((status IS NULL) OR (status='P') OR (status='C'))
  ENABLE VALIDATE);
ALTER TABLE PATS.NOTIFICATION_MASTER
  DROP CONSTRAINT CK_NOTIFICATION_TYPE;

ALTER TABLE PATS.NOTIFICATION_MASTER ADD (
  CONSTRAINT CK_NOTIFICATION_TYPE
  CHECK ("NOTIFICATION_TYPE"='IN' OR "NOTIFICATION_TYPE"='ARN')
  ENABLE VALIDATE);
ALTER TABLE PATS.NOTIFICATION_MASTER MODIFY 
  ROC_FK NULL;

ALTER TABLE PATS.NOTIFICATION_MASTER MODIFY 
  ROC_FK NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.NOTIFICATION_MASTER MODIFY 
  PATIENT_ADVOCATE_USER_FK NULL;

ALTER TABLE PATS.NOTIFICATION_MASTER MODIFY 
  PATIENT_ADVOCATE_USER_FK NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.NOTIFICATION_MASTER MODIFY 
  DATE_INITIATED NULL;

ALTER TABLE PATS.NOTIFICATION_MASTER MODIFY 
  DATE_INITIATED NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.NOTIFICATION_MASTER MODIFY 
  NOTIFICATION_TYPE NULL;

ALTER TABLE PATS.NOTIFICATION_MASTER MODIFY 
  NOTIFICATION_TYPE NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.NOTIFICATION_MASTER MODIFY 
  QUERYSTRING NULL;

ALTER TABLE PATS.NOTIFICATION_MASTER MODIFY 
  QUERYSTRING NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.NOTIFICATION_MASTER MODIFY 
  EMPLOYEE_NOTIFIED_FK NULL;

ALTER TABLE PATS.NOTIFICATION_MASTER MODIFY 
  EMPLOYEE_NOTIFIED_FK NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.NOTIFICATION_DETAIL MODIFY 
  ID NULL;

ALTER TABLE PATS.NOTIFICATION_DETAIL MODIFY 
  ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.NOTIFICATION_DETAIL MODIFY 
  NOTIFICATION_MASTER_FK NULL;

ALTER TABLE PATS.NOTIFICATION_DETAIL MODIFY 
  NOTIFICATION_MASTER_FK NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.NOTIFICATION_DETAIL MODIFY 
  TO_USER_FK NULL;

ALTER TABLE PATS.NOTIFICATION_DETAIL MODIFY 
  TO_USER_FK NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.NOTIFICATION_DETAIL MODIFY 
  FROM_USER_FK NULL;

ALTER TABLE PATS.NOTIFICATION_DETAIL MODIFY 
  FROM_USER_FK NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.PAD_LOCATION MODIFY 
  ID NULL;

ALTER TABLE PATS.PAD_LOCATION MODIFY 
  ID NOT NULL
  ENABLE VALIDATE;
ALTER TABLE PATS.PAD_LOCATION MODIFY 
  PATS_STATION NULL;

ALTER TABLE PATS.PAD_LOCATION MODIFY 
  PATS_STATION NOT NULL
  ENABLE VALIDATE;
